<?php include('header.php');?>

<main id="dashboard">
    <div class="container">

        <div class="row">

            <div class="col-sm-9">

                <div class="page-title">
                    <h1><strong> Manage Users </strong>
                </div>

            </div>

            <div class="col-sm-3 text-right">
                <a href="<?php echo baseUrl('add_user.php');?>" class="btn btn-lg btn-info btn-block">Add New User</a>
                <br>
            </div>

        </div>
        <div class="row">
            <div class="col-sm-9">
                <?php include('cron_info.php');?>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">

                <div class="panel panel-fb">

                    <div class="panel-body">
                        <form id="edit_user_form" action="<?php echo baseUrl('add_user.php');?>" method="post">
                            <input type="hidden" name="edit_user" value="edit">
                            <input type="hidden" name="uid">
                        </form>

                        <form action="<?php echo baseUrl('users.php')?>" class="form-horizontal" method="post">
                            <input type="hidden" name="submit" value="search_users">
                            <div class="form-inline">

                                <div class="form-group col-sm-12 col-md-5">
                                    <div class="row">

                                        <label  class="radio-inline ptn pln" for="exampleInputEmail3">Search by name/email:</label>

                                        <div class="input-group col-sm-5 col-xs-12">
                                            <input type="text" name="search_name" value="<?php if(!empty($search_name)) echo $search_name; ?>" class="form-control">
                                        </div>

                                    </div>
                                </div>

                                <div class="form-group col-sm-8 col-md-6">


                                    <label  class="radio-inline" for="exampleInputEmail3">Show : </label>

                                    <label class="radio-inline">
                                        <input name="user_status" id="inlineRadio1" value="all" type="radio" <?php if($search_status == 'all') echo 'checked'; ?>>All users
                                    </label>

                                    <label class="radio-inline">
                                        <input name="user_status" id="inlineRadio2" value="1" type="radio" <?php if($search_status == '1') echo 'checked'; ?>>Active
                                    </label>

                                    <label class="radio-inline">
                                        <input name="user_status" id="inlineRadio2" value="0" type="radio" <?php if($search_status == '0') echo 'checked'; ?>>Inactive
                                    </label>

                                </div>

                                <div class="form-group">

                                    <button type="submit" class="btn btn-info btn-filter"><i class="fa fa-filter"></i> Filter</button>

                                </div>

                            </div>

                        </form>
                    </div>

                    <table class="table table-striped">
                        <thead>

                        <tr>
                            <th class="col-xs-4 col-sm-4">Name</th>
                            <th class="col-xs-5 col-sm-5">Detials</th>
                            <th class="col-xs-3 col-sm-3"> </th>
                        </tr>

                        </thead>

                        <tbody>
                        <?php foreach($all_users as $user) { ?>
                            <tr>
                                <td class="user-page">
                                    <?php if(!empty($user['fb_user_id'])) { ?>
                                        <img class="user-pic" src="https://graph.facebook.com/<?php echo $user['fb_user_id'];?>/picture" alt="">
                                    <?php } else { ?>
                                        <img class="user-pic" src="<?php echo assetsPath();?>img/picture.png" alt="">
                                    <?php } ?>
                                    <span class="user-name"> <?php echo empty($user['fb_user_name']) ? $user['name'] : $user['fb_user_name'];?></span>
										<span class="user-info">
											<span class="user-num"><?php echo empty($user['last_login']) ? 'Never' : date('m/d/Y H:i',to_my_timezone($user['last_login']));?></span>

										</span>
                                </td>
                                <td class="user-detials">
                                    <span class="user-mail">Email: <?php echo $user['email']?></span>
                                    <span class="user-id">Name: <?php echo $user['name'];?></span>
                                    <span class="user-status">Status: <?php echo ($user['status'] == 1) ? 'Active' : 'Inactive';?></span>
                                </td>
                                <td class="text-right user-actions">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-gray dropdown-toggle" data-toggle="dropdown">
                                            Options <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                            <li><a id="edit_user" href="#" data-id="<?php echo base64_encode($user['id']);?>">Edit User</a></li>
                                            <li><a id="change_user_status" data-id="<?php echo base64_encode($user['id']);?>" href="#"><?php echo ($user['status'] == 1) ? 'Disable' : 'Enable';?> User</a></li>
                                            <li><a id="delete_user" data-id="<?php echo base64_encode($user['id']);?>" href="#">Delete User</a></li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include('footer.php');?>